| package |
package := Package name: 'CU Tools Base'.
package paxVersion: 1;
	basicComment: 'Copyright  Chris Uppal, 2001.
chris.uppal@metagnostic.org

A very small framework that I use to give my applications a common look.

The terms under which you may use this software are:
	You must not claim that you wrote it.
	You must not claim that you own it.
	You use it at your own risk.

I''d appreciate it if you didn''t distribute modified versions without at least trying to tell me about the changes you thought worthwhile.

	-- chris
'.

package basicPackageVersion: '0.0012'.

package basicScriptAt: #postinstall put: '(Package manager packageNamed: ''CU Tools Base'')
	propertyAt: #ExternalResourceFileNames
	put: #(''Resources\Metagnostic.ico'').
!!'.

package classNames
	add: #CUToolShell;
	add: #CUWizardShell;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: 'CU PackageResourceLocator';
	add: '..\Object Arts\Dolphin\IDE\Base\Development System';
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\Object Arts\Dolphin\MVP\Views\Cards\Dolphin Card Containers';
	add: '..\Object Arts\Dolphin\MVP\Base\Dolphin MVP Base';
	add: '..\Object Arts\Dolphin\Registry\Dolphin Registry Access';
	add: '..\Object Arts\Dolphin\MVP\Type Converters\Dolphin Type Converters';
	yourself).

package!

"Class Definitions"!

Shell subclass: #CUToolShell
	instanceVariableNames: 'isTopMost'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
CUToolShell subclass: #CUWizardShell
	instanceVariableNames: 'pageNumber pages'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

CUToolShell guid: (GUID fromString: '{39327820-5EFE-11D4-8725-98CF9948BA36}')!
CUToolShell comment: 'Copyright  Chris Uppal, 2001.
chris.uppal@metagnostic.org

Simple base class to reduce, very slightly, the quantity of boilerplate code which is duplicated from application to application.
'!
!CUToolShell categoriesForClass!Unclassified! !
!CUToolShell methodsFor!

bugs
	"command -- display the bugs-box"

	MessageBox
		warning: self class bugs
		caption: ('Known bugs in ' , self class toolName).!

canForgetWindowSize
	"command -- can we forget preferred size for windows"

	^ self class defaultExtent notNil.!

captionExtension: aString
	"set the caption to our tool name followed (if aString is non-empty)
	by ' - ' and then aString"

	| cap |

	cap := self class toolName.

	(aString isNil or: [aString isEmpty]) ifFalse:
		[cap := cap , ' - ' , aString].

	self caption: cap.!

confirm: aString
	"popup a message box to confirm the given question"

	^ MessageBox
		confirm: aString
		caption: self class toolName.!

forgetWindowSize
	"command -- forget preferred size for windows"

	self class defaultExtent: nil.!

help
	"command -- display the help-box"

	MessageBox
		notify: self class help
		caption: ('Help for ' , self class toolName).!

helpAbout
	"command -- display the about-box"

	MessageBox
		notify: self class about
		caption: ('About ' , self class toolName).!

initialize
	"private -- establish coherent inital state"

	isTopMost := false.
	self captionExtension: nil.
	^ super initialize.!

queryCommand: aCommandQuery
	"private -- set the enabledness etc of aCommandQuery"

	| cmd enabled checked |

	super queryCommand: aCommandQuery.
	cmd := aCommandQuery command.
	enabled := aCommandQuery isEnabled.
	checked := aCommandQuery isChecked.

	cmd == #toggleTopMost ifTrue: [checked := isTopMost].
	cmd = #forgetWindowSize ifTrue: [enabled := self canForgetWindowSize].

	aCommandQuery
		isEnabled: enabled;
		isChecked: checked.
!

rememberWindowSize
	"command -- make the current window size be the preferred size"

	self class defaultExtent: self view extent.!

show
	"shows the view of the receiver using the default extent, if any"

	| extent |

	extent := self class defaultExtent.
	extent isNil ifFalse: [self view extent: extent].

	^ super show.!

todo
	"command -- display the todo-box"

	MessageBox
		notify: self class todo
		caption: ('Known deficiencies in ' , self class toolName).
!

toggleTopMost
	"command -- toggle whether this is a 'topmost' window"

	(isTopMost := isTopMost not)
		ifTrue: [self view beTopMost]
		ifFalse: [self view beNotTopMost].! !
!CUToolShell categoriesFor: #bugs!commands!public! !
!CUToolShell categoriesFor: #canForgetWindowSize!commands!public! !
!CUToolShell categoriesFor: #captionExtension:!accessing!public! !
!CUToolShell categoriesFor: #confirm:!helpers!public! !
!CUToolShell categoriesFor: #forgetWindowSize!commands!public! !
!CUToolShell categoriesFor: #help!commands!public! !
!CUToolShell categoriesFor: #helpAbout!commands!public! !
!CUToolShell categoriesFor: #initialize!initializing!private! !
!CUToolShell categoriesFor: #queryCommand:!commands!private! !
!CUToolShell categoriesFor: #rememberWindowSize!commands!public! !
!CUToolShell categoriesFor: #show!operations!public! !
!CUToolShell categoriesFor: #todo!commands!public! !
!CUToolShell categoriesFor: #toggleTopMost!commands!private! !

!CUToolShell class methodsFor!

about
	"answer a string very briefly describing ourself"

#subclassResponsibility.

	^ 'CU ToolShell.  Version 0.
Copyright  Chris Uppal, 2000-2003.
chris.uppal@metagnostic.org'.
!

bugs
	"answer a String describing the less than outstanding work"

	#subclassResponsibility.
	^ 'implement %s class>>#bugs !!' sprintfWith: self name.
!

defaultExtent
	"Answer a <Point> which is the user's chosen default extent for new instances
	of the receiver, or nil if left up to Windows."

	| entry |

	entry := self registryEntry at: #defaultExtent ifAbsent: [^ nil].
	^ (entry valueAt: 'x' ifAbsent: [400]) @ (entry valueAt: 'y' ifAbsent: [500]).!

defaultExtent: aPointOrNil
	"set the receiver's defaultExtent to aPointOrNil"

	aPointOrNil isNil
		ifTrue:
			[self removeRegistryAt: #defaultExtent]
		ifFalse:
			[(self registryAt: #defaultExtent)
				valueAt: 'x' put: aPointOrNil x;
				valueAt: 'y' put: aPointOrNil y].

	self trigger: #defaultExtentChanged.
!

defaultIconName
	"answers the name of the Icon that can be used to represent this class"

	^ 'Metagnostic.ico'.!

description
	"answer a string briefly describing ourself"

	#subclassResponsibility.
	^ self comment.	"handy hack"!

help
	"answer our help text"

	"hacky, very hacky..."
	^ self description.!

icon
	"answers an Icon that can be used to represent this class"

	"this will have to be recompiled if the package we live in changes its name"


	^(Smalltalk at: #Icon) fromFile: self defaultIconName
		usingLocator: (PackageResourceLocator packageNamed: ##(self owningPackage name))!

initialize
	"private -- class-side initialisation
		self initialize
	"

	self reuseIfOpen: true.
!

publishedAspects
	"answer our aspects as a Set"

	^ super publishedAspects
		add: (Aspect boolean: #reuseIfOpen);
		add: (Aspect name: #defaultExtent);
		yourself.
!

publishedEvents
	"answer our published events"

	^ super publishedEvents
		add: #reuseIfOpenChanged;
		add: #defaultExtentChanged;
		yourself.
!

registerAsTool
	"add ourself to the 'system tools'"

	| icon |

	"add ourself to the 'Extra tools' folder"
	icon := (Smalltalk at: #SmalltalkSystemIcon) show: self description: self toolName.
	(Smalltalk at: #SmalltalkSystem) current addAdditionalToolsFolderIcon: icon.

	"add ourself to the 'Dolphin Options' set"
	(Smalltalk at: #SmalltalkSystem) registerTool: self.
!

registryAt: aString
	"private -- answer the registry entry with the given name, creating it if necesary"

	^ self registryEntry createKey: aString.
!

registryAt: aString put: aValue
	"private -- set the value associated with aString in our registry entry.
	answers the new entry (not its value)"

	^ (self registryAt: aString)
		value: aValue;
		yourself.
!

registryEntry
	"private -- answer a RegKey representing the root of our registry entry"

	^ self registryEntryRoot createKey: self registryKeyName.
!

registryEntryRoot
	"private -- answer a RegKey representing the root of our registry entry"

	^ RegKey userRoot createKey: self registryRootName.
!

registryKeyName
	"private -- answer the name of our registy entry within the root"

	^ self toolName.!

registryRootName
	"private -- answer the name of the root of our registy entry"

	^ 'Software\Metagnostic'.!

registryValue: aString default: aValue
	"private -- answer the registry value associated with aString, setting it to aValue if it is
	not already present"

	^ (self registryEntry at: aString ifAbsent: [self registryAt: aString put: aValue]) value.
!

removeRegistryAt: aString
	"private -- remove the registry entry with the given name"

	^ self registryEntry removeKey: aString ifAbsent: [].
!

resource_Default_view
	"Answer the literal data from which the 'Default view' resource can be reconstituted.
	DO NOT EDIT OR RECATEGORIZE THIS METHOD.

	If you wish to modify this resource evaluate:
	ViewComposer openOn: (ResourceIdentifier class: self selector: #resource_Default_view)
	"

	^#(#'!!STL' 3 788558 10 ##(Smalltalk.STBViewProxy)  8 ##(Smalltalk.ShellView)  98 27 0 0 98 2 27131905 131073 416 0 524550 ##(Smalltalk.ColorRef)  8 4278190080 0 517 0 0 0 416 0 234 256 98 0 0 461638 4 ##(Smalltalk.MenuBar)  0 16 98 2 265030 4 ##(Smalltalk.Menu)  0 16 98 1 610 0 16 98 4 984134 2 ##(Smalltalk.CommandMenuItem)  1 1180998 4 ##(Smalltalk.CommandDescription)  8 #toggleTopMost 8 'Always on &Top' 8361 1 0 0 0 983366 1 ##(Smalltalk.DividerMenuItem)  4097 690 1 722 8 #rememberWindowSize 8 '&Remember this size' 1 1 0 0 0 690 1 722 8 #forgetWindowSize 8 '&Forget size' 1 1 0 0 0 8 '&Options' 0 1 0 0 15813 0 0 8 '&Tools' 0 1 0 0 15815 0 0 610 0 16 98 6 690 1 722 8 #help 8 '&Help on this tool' 225 1 0 0 0 786 4097 690 1 722 8 #helpAbout 8 '&About this tool' 1 1 0 0 0 786 4097 690 1 722 8 #bugs 8 '&Bugs' 1 1 0 0 0 690 1 722 8 #todo 8 '&Todo' 1 1 0 0 0 8 '&Help' 0 1 0 0 15825 0 0 8 '' 0 1 0 0 0 0 0 0 0 0 1 0 0 0 0 1 0 0 983302 ##(Smalltalk.MessageSequence)  202 208 98 3 721670 ##(Smalltalk.MessageSend)  8 #createAt:extent: 98 2 328198 ##(Smalltalk.Point)  89 117 1458 2881 1701 416 1394 8 #text: 98 1 8 'CU ToolShell' 416 1394 8 #updateMenuBar 544 416 983302 ##(Smalltalk.WINDOWPLACEMENT)  8 #[44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 44 0 0 0 58 0 0 0 204 5 0 0 140 3 0 0] 98 0 1458 193 193 0 27 )!

reuseIfOpen
	"answer the receiver's reuseIfOpen aspect"

	^ (self registryValue: #reuseIfOpen default: 0) = 1.
!

reuseIfOpen: aBool
	"set the receiver's reuseIfOpen aspect"

	self registryAt: #reuseIfOpen put: (aBool ifTrue: [1] ifFalse: [0]).
	self trigger: #reuseIfOpenChangedChanged.
!

show
	"shows an instance of the receiver, overridden to implement the reuse if open stuff"

	| it |

	self reuseIfOpen ifFalse: [^ super show].
	it := self allInstances detect: [:each | each isOpen] ifNone: [^ super show].
	it view zOrderTop; show.

	^ it.!

show: aViewName on: anObject asToolboxFor: aView
	"shows an instance of the receiver on the given Object as its model, and displayed
	as a toolbox view attached to aView"

	| new newView |

	new := self on: anObject.

	newView := self loadViewResource: aViewName inContext: View desktop.
	newView bePopupFor: aView.
	newView largeIcon: (aView topShell view largeIcon).
	new view: newView.

	^ new show.!

showOn: aModel
	"show and answer a new instance dislaying aModel.
	NB: ignores the reuseIfOpen stuff"

	^ super showOn: aModel.!

showOn: anObject asToolboxFor: aView
	"shows an instance of the receiver on the given Object as its model, and displayed
	as a toolbox view attached to aView"

	^ self show: self defaultView on: anObject asToolboxFor: aView.!

todo
	"answer a String describing the outstanding work"

	#subclassResponsibility.
	^ 'implement %s class>>#todo !!' sprintfWith: self name.
!

toolName
	"answer the Sting name to use for the name of the tool we define"

	| base stream lastWasUpper |

	base := self name.
	(base endsWith: 'Shell') ifTrue: [base := base allButLast: 5].

	"useful default implementation"
	stream := String writeStream.
	lastWasUpper := true.
	base do:
		[:each || isUpper |
		isUpper := each isUppercase.
		(isUpper and: [lastWasUpper not]) ifTrue: [stream space].
		lastWasUpper := isUpper.
		stream nextPut: each].

	^ stream contents.!

unRegisterAsTool
	"remove ourself from the 'system tools'"

	| icon |

	"remove ourself from the 'Extra tools' folder"
	icon := (Smalltalk at: #SmalltalkSystemIcon) show: self description: self toolName.
	(Smalltalk at: #SmalltalkSystem) current removeSystemFolderIcon: icon.

	"remove ourself from the 'Dolphin Options' set"
	(Smalltalk at: #SmalltalkSystem) unregisterTool: self.
! !
!CUToolShell class categoriesFor: #about!documentation!public! !
!CUToolShell class categoriesFor: #bugs!documentation!public! !
!CUToolShell class categoriesFor: #defaultExtent!accessing!public! !
!CUToolShell class categoriesFor: #defaultExtent:!accessing!public! !
!CUToolShell class categoriesFor: #defaultIconName!constants!public! !
!CUToolShell class categoriesFor: #description!documentation!public! !
!CUToolShell class categoriesFor: #help!documentation!public! !
!CUToolShell class categoriesFor: #icon!constants!public! !
!CUToolShell class categoriesFor: #initialize!development!initializing!private! !
!CUToolShell class categoriesFor: #publishedAspects!constants!must strip!public! !
!CUToolShell class categoriesFor: #publishedEvents!constants!public! !
!CUToolShell class categoriesFor: #registerAsTool!development!initializing!public! !
!CUToolShell class categoriesFor: #registryAt:!accessing!private!registry! !
!CUToolShell class categoriesFor: #registryAt:put:!accessing!private!registry! !
!CUToolShell class categoriesFor: #registryEntry!accessing!private!registry! !
!CUToolShell class categoriesFor: #registryEntryRoot!accessing!private!registry! !
!CUToolShell class categoriesFor: #registryKeyName!constants!private!registry! !
!CUToolShell class categoriesFor: #registryRootName!constants!private!registry! !
!CUToolShell class categoriesFor: #registryValue:default:!accessing!private!registry! !
!CUToolShell class categoriesFor: #removeRegistryAt:!accessing!private!registry! !
!CUToolShell class categoriesFor: #resource_Default_view!public!resources-views! !
!CUToolShell class categoriesFor: #reuseIfOpen!accessing!public! !
!CUToolShell class categoriesFor: #reuseIfOpen:!accessing!public! !
!CUToolShell class categoriesFor: #show!instance creation!public! !
!CUToolShell class categoriesFor: #show:on:asToolboxFor:!instance creation!public! !
!CUToolShell class categoriesFor: #showOn:!instance creation!public! !
!CUToolShell class categoriesFor: #showOn:asToolboxFor:!instance creation!public! !
!CUToolShell class categoriesFor: #todo!documentation!public! !
!CUToolShell class categoriesFor: #toolName!constants!displaying!public! !
!CUToolShell class categoriesFor: #unRegisterAsTool!development!initializing!public! !

CUWizardShell guid: (GUID fromString: '{9BA61CB1-C56A-4BDD-8C8A-EFE5EAE78267}')!
CUWizardShell comment: 'Copyright  Chris Uppal, 2001.
chris.uppal@metagnostic.org'!
!CUWizardShell categoriesForClass!Unclassified! !
!CUWizardShell methodsFor!

additionalAccelerators
	"overriden to add F1 help (since we don't pick it up from the menu bar, us not
	having one)"

	^ super additionalAccelerators , #(#(#help 'F1'))!

canCancel
	"private -- answer true iff we may perform the #cancel command ?"

	"override if necessary"
	^ true.
!

cancel
	"command -- cancel this wizard"

	self canCancel ifFalse: [^ self].

	self view exit.
!

canFinish
	"private -- answer true iff we may perform the #finish command ?"

	^ self isOnFinalPage.
!

canNextPage
	"private -- answer true iff we may perform the #nextPage command ?"

	^ self isOnFinalPage not.
!

canPreviousPage
	"private -- answer true iff we may perform the #previousPage command ?"

	^ self isOnFirstPage not.
!

createComponents
	"private -- create subpresenters for our various subviews"

	super createComponents.

	self add: Presenter new name: 'Pages'.

	1 to: self maxPages do:
		[:i || page |
		page := Presenter new.
		pages addLast: page.
		self add: page name: ('Page%d' sprintfWith: i)].

!

createSchematicWiring
	"private - arrange triggering between our components"

	super createSchematicWiring.

	self pagesPresenter view
		when: #currentCardChanged
		send: #onPageChanged
		to: self.
!

currentPage
	"answer the presenter of the current page"

	^ pages at: pageNumber.!

finish
	"command -- finish the wizard's operation"

	self canFinish ifFalse: [^ self].

	Error notYetImplemented.
!

finishButton
	"private -- answer the view named 'finishButton'"

	^ self view viewNamed: 'finishButton' .
!

initialize
	"private -- establish coherent inital state"

	pageNumber := 0.
	pages := OrderedCollection new.
	^ super initialize.!

isOnFinalPage
	"answer whether we are currently displaying the final page"

	^ pageNumber = self maxPages.!

isOnFirstPage
	"answer whether we are currently displaying the first page"

	^ pageNumber = 1.!

maxPages
	"answer how many pages we have"

	"override as necessary"
	^ 5.!

nextPage
	"command -- switch to the next page"

	self canNextPage ifFalse: [^ self].

	pageNumber := pageNumber + 1.
	self pagesPresenter view nextCard.!

nextPageButton
	"private -- answer the view named 'nextPageButton'"

	^ self view viewNamed: 'nextPageButton'.
!

onPageChanged
	"private -- invoked when the displayed page has changed"

	self isOnFirstPage
		ifTrue: [self previousPageButton hide]
		ifFalse: [self previousPageButton show].

	self isOnFinalPage
		ifTrue: [self nextPageButton hide. self finishButton show; isDefault: true]
		ifFalse: [self finishButton hide. self nextPageButton show; isDefault: true].
!

onViewOpened
	"private -- called when the view has been connected and we are ready to roll"

	super onViewOpened.
	pageNumber := 1.
	self onPageChanged.!

page: anInteger
	"answer the presenter of the indexed page"

	^ pages at: anInteger.!

pageNumber
	"answer the number of the current page"

	^ pageNumber.!

pagesPresenter
	"answer the presenter named 'Pages'"

	^ self presenterNamed: 'Pages'.
!

previousPage
	"command -- switch to the previous"

	self canPreviousPage ifFalse: [^ self].

	pageNumber := pageNumber - 1.
	self pagesPresenter view previousCard.!

previousPageButton
	"private -- answer the view named 'previousPageButton'"

	^ self view viewNamed: 'previousPageButton'.
!

queryCommand: aCommandQuery
	"private -- set the enabledness etc of aCommandQuery"

	| cmd enabled checked |

	super queryCommand: aCommandQuery.
	cmd := aCommandQuery command.
	enabled := aCommandQuery isEnabled.

	cmd = #cancel ifTrue: [enabled := self canCancel].
	cmd = #finish ifTrue: [enabled := self canFinish].
	cmd = #nextPage ifTrue: [enabled := self canNextPage].
	cmd = #previousPage ifTrue: [enabled := self canPreviousPage].

	aCommandQuery isEnabled: enabled.
! !
!CUWizardShell categoriesFor: #additionalAccelerators!constants!public! !
!CUWizardShell categoriesFor: #canCancel!commands!private! !
!CUWizardShell categoriesFor: #cancel!commands!public! !
!CUWizardShell categoriesFor: #canFinish!commands!private! !
!CUWizardShell categoriesFor: #canNextPage!commands!private! !
!CUWizardShell categoriesFor: #canPreviousPage!commands!private! !
!CUWizardShell categoriesFor: #createComponents!initializing!private!subpresenters! !
!CUWizardShell categoriesFor: #createSchematicWiring!event handling!initializing!private! !
!CUWizardShell categoriesFor: #currentPage!pages!public! !
!CUWizardShell categoriesFor: #finish!commands!public! !
!CUWizardShell categoriesFor: #finishButton!private!subpresenters! !
!CUWizardShell categoriesFor: #initialize!initializing!private! !
!CUWizardShell categoriesFor: #isOnFinalPage!pages!public! !
!CUWizardShell categoriesFor: #isOnFirstPage!pages!public! !
!CUWizardShell categoriesFor: #maxPages!constants!pages!public! !
!CUWizardShell categoriesFor: #nextPage!commands!pages!public! !
!CUWizardShell categoriesFor: #nextPageButton!private!subpresenters! !
!CUWizardShell categoriesFor: #onPageChanged!event handling!pages!private! !
!CUWizardShell categoriesFor: #onViewOpened!event handling!public! !
!CUWizardShell categoriesFor: #page:!pages!public! !
!CUWizardShell categoriesFor: #pageNumber!pages!public! !
!CUWizardShell categoriesFor: #pagesPresenter!public!subpresenters! !
!CUWizardShell categoriesFor: #previousPage!commands!pages!public! !
!CUWizardShell categoriesFor: #previousPageButton!private!subpresenters! !
!CUWizardShell categoriesFor: #queryCommand:!commands!private! !

!CUWizardShell class methodsFor!

resource_Default_view
	"Answer the literal data from which the 'Default view' resource can be reconstituted.
	DO NOT EDIT OR RECATEGORIZE THIS METHOD.

	If you wish to modify this resource evaluate:
	ViewComposer openOn: (ResourceIdentifier class: self selector: #resource_Default_view)
	"

	^#(#'!!STL' 3 788558 10 ##(Smalltalk.STBViewProxy)  8 ##(Smalltalk.ShellView)  98 27 0 0 98 2 27131905 131073 416 0 721158 ##(Smalltalk.SystemColor)  31 328198 ##(Smalltalk.Point)  841 931 517 0 0 0 416 852230 ##(Smalltalk.FramingLayout)  234 240 98 6 410 8 ##(Smalltalk.StaticRectangle)  98 14 0 416 98 2 8 1140916487 262145 608 0 524550 ##(Smalltalk.ColorRef)  8 4278190080 0 5 0 0 0 608 0 8 4294902357 983302 ##(Smalltalk.MessageSequence)  202 208 98 1 721670 ##(Smalltalk.MessageSend)  8 #createAt:extent: 98 2 514 11 807 514 805 5 608 983302 ##(Smalltalk.WINDOWPLACEMENT)  8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 147 1 0 0 151 1 0 0 149 1 0 0] 98 0 514 193 193 0 27 1181766 2 ##(Smalltalk.FramingConstraints)  1114638 ##(Smalltalk.STBSingletonProxy)  8 ##(Smalltalk.FramingCalculation)  8 #fixedPreviousLeft 1 1034 1056 8 #fixedPreviousRight 1 1034 1056 8 #fixedPreviousBottom 11 1034 1056 8 #fixedViewTop 5 410 8 ##(Smalltalk.ContainerView)  98 15 0 416 98 2 8 1140850688 131073 1184 0 482 31 0 5 0 0 0 1184 546 234 240 98 10 410 8 ##(Smalltalk.PushButton)  98 17 0 1184 98 2 8 1140924416 1 1328 0 690 720 0 5 0 0 0 1328 0 8 4294902421 1180998 4 ##(Smalltalk.CommandDescription)  8 #help 8 '&Help' 1 1 0 0 32 754 202 208 98 2 818 848 98 2 514 1 1 514 121 47 1328 818 8 #text: 98 1 8 '&Help' 1328 914 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 60 0 0 0 23 0 0 0] 98 0 976 0 27 994 1034 1056 8 #fixedParentLeft 1 1034 1056 8 #fixedViewLeft 121 1034 1056 8 #fixedParentTop 1 1034 1056 8 #fixedParentBottom 1 410 1344 98 17 0 1184 98 2 8 1140924416 1 1872 0 690 720 0 5 0 0 0 1872 0 8 4294902421 1442 8 #previousPage 8 '< &Back' 1 1 0 0 32 754 202 208 98 2 818 848 98 2 514 375 1 514 121 47 1872 818 1632 98 1 8 '< &Back' 1872 914 8 #[44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 187 0 0 0 0 0 0 0 247 0 0 0 23 0 0 0] 98 0 976 0 27 994 1034 1056 8 #fixedViewRight -119 1034 1056 8 #fixedParentRight -309 1808 1 1840 1 410 1344 98 17 0 1184 98 2 8 1140924416 1 2304 0 690 720 0 5 0 0 0 2304 0 8 4294902421 1442 8 #finish 8 '&Finish' 1 1 0 0 32 754 202 208 98 2 818 848 98 2 514 505 1 514 121 47 2304 818 1632 98 1 8 '&Finish' 2304 914 8 #[44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 252 0 0 0 0 0 0 0 56 1 0 0 23 0 0 0] 98 0 976 0 27 994 2240 -119 2272 -179 1808 1 1840 1 410 1344 98 17 0 1184 98 2 8 1140924416 1 2672 0 690 720 0 5 0 0 0 2672 0 8 4294902421 1442 8 #nextPage 8 '&Next >' 1 1 0 0 16 754 202 208 98 2 818 848 98 2 514 505 1 514 121 47 2672 818 1632 98 1 8 '&Next >' 2672 914 8 #[44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 252 0 0 0 0 0 0 0 56 1 0 0 23 0 0 0] 98 0 976 0 27 994 2240 -119 2272 -179 1808 1 1840 1 410 1344 98 17 0 1184 98 2 8 1140924416 1 3040 0 690 720 0 5 0 0 0 3040 0 8 4294902421 1442 8 #cancel 8 'Cancel' 1 1 0 0 32 754 202 208 98 2 818 848 98 2 514 685 1 514 121 47 3040 818 1632 98 1 8 'Cancel' 3040 914 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 86 1 0 0 0 0 0 0 146 1 0 0 23 0 0 0] 98 0 976 0 27 994 2240 -119 2272 1 1808 1 1840 1 234 256 98 6 1872 8 'previousPageButton' 2304 8 'finishButton' 2672 8 'nextPageButton' 0 754 202 208 98 1 818 848 98 2 514 11 821 514 805 47 1184 914 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 154 1 0 0 151 1 0 0 177 1 0 0] 98 5 1328 1872 2672 3040 2304 976 0 27 994 1040 1 1088 1 1120 11 1840 -9 410 8 ##(Smalltalk.WizardCardContainer)  98 15 0 416 98 2 8 1140850688 131073 3664 0 482 31 0 5 0 0 0 3664 655878 ##(Smalltalk.CardLayout)  202 208 98 5 721414 ##(Smalltalk.Association)  3 410 1200 98 15 0 3664 98 2 8 1140850688 131073 3856 0 482 31 0 5 0 0 0 3856 546 234 240 98 2 410 8 ##(Smalltalk.StaticText)  98 16 0 3856 98 2 8 1140850945 1 3984 0 0 0 5 0 0 0 3984 0 8 4294902357 852486 ##(Smalltalk.NullConverter)  0 0 0 754 202 208 98 2 818 848 98 2 514 1 1 514 805 787 3984 818 1632 98 1 8 'Page 1' 3984 914 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 146 1 0 0 137 1 0 0] 98 0 976 0 27 994 1744 1 2272 1 1808 1 1840 1 234 256 98 0 0 754 202 208 98 1 818 848 98 2 514 1 1 514 805 787 3856 914 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 146 1 0 0 137 1 0 0] 98 1 3984 976 0 27 3826 5 410 1200 98 15 0 3664 98 2 8 1140850688 131073 4544 0 482 31 0 5 0 0 0 4544 546 234 240 98 2 410 4000 98 16 0 4544 98 2 8 1140850945 1 4672 0 0 0 5 0 0 0 4672 0 8 4294902357 4082 0 0 0 754 202 208 98 2 818 848 98 2 514 1 1 514 805 787 4672 818 1632 98 1 8 'Page 2' 4672 914 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 146 1 0 0 137 1 0 0] 98 0 976 0 27 994 1744 1 2272 1 1808 1 1840 1 234 256 4352 0 754 202 208 98 1 818 848 98 2 514 1 1 514 805 787 4544 914 8 #[44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 146 1 0 0 137 1 0 0] 98 1 4672 976 0 27 3826 7 410 1200 98 15 0 3664 98 2 8 1140850688 131073 5184 0 482 31 0 5 0 0 0 5184 546 234 240 98 2 410 4000 98 16 0 5184 98 2 8 1140850945 1 5312 0 0 0 5 0 0 0 5312 0 8 4294902357 4082 0 0 0 754 202 208 98 2 818 848 98 2 514 1 1 514 805 787 5312 818 1632 98 1 8 'Page 3' 5312 914 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 146 1 0 0 137 1 0 0] 98 0 976 0 27 994 1744 1 2272 1 1808 1 1840 1 234 256 4352 0 754 202 208 98 1 818 848 98 2 514 1 1 514 805 787 5184 914 8 #[44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 146 1 0 0 137 1 0 0] 98 1 5312 976 0 27 3826 9 410 1200 98 15 0 3664 98 2 8 1140850688 131073 5824 0 482 31 0 5 0 0 0 5824 546 234 240 98 2 410 4000 98 16 0 5824 98 2 8 1140850945 1 5952 0 0 0 5 0 0 0 5952 0 8 4294902357 4082 0 0 0 754 202 208 98 2 818 848 98 2 514 1 1 514 805 787 5952 818 1632 98 1 8 'Page 4' 5952 914 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 146 1 0 0 137 1 0 0] 98 0 976 0 27 994 1744 1 2272 1 1808 1 1840 1 234 256 4352 0 754 202 208 98 1 818 848 98 2 514 1 1 514 805 787 5824 914 8 #[44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 146 1 0 0 137 1 0 0] 98 1 5952 976 0 27 3826 11 410 1200 98 15 0 3664 98 2 8 1140850688 131073 6464 0 482 31 0 5 0 0 0 6464 546 234 240 98 2 410 4000 98 16 0 6464 98 2 8 1140850945 1 6592 0 0 0 5 0 0 0 6592 0 8 4294902357 4082 0 0 0 754 202 208 98 2 818 848 98 2 514 1 1 514 805 787 6592 818 1632 98 1 8 'Page 5' 6592 914 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 146 1 0 0 137 1 0 0] 98 0 976 0 27 994 1744 1 2272 1 1808 1 1840 1 234 256 4352 0 754 202 208 98 1 818 848 98 2 514 1 1 514 805 787 6464 914 8 #[44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 0 0 0 0 0 0 0 146 1 0 0 137 1 0 0] 98 1 6592 976 0 27 3856 234 256 98 10 6464 8 'Page5' 3856 8 'Page1' 4544 8 'Page2' 5824 8 'Page4' 5184 8 'Page3' 0 754 202 208 98 1 818 848 98 2 514 11 11 514 805 787 3664 914 8 #[44 0 0 0 0 0 0 0 1 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 5 0 0 0 5 0 0 0 151 1 0 0 142 1 0 0] 98 5 3856 4544 5184 5824 6464 976 0 27 994 1744 11 2272 -9 1808 11 1840 -79 234 256 98 2 3664 8 'Pages' 0 0 0 0 0 11785 0 0 0 0 1 0 0 754 202 208 98 3 818 848 98 2 514 133 175 514 841 931 416 818 1632 98 1 8 'CU WizardShell' 416 818 8 #updateMenuBar 4352 416 914 8 #[44 0 0 0 0 0 0 0 0 0 0 0 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 66 0 0 0 87 0 0 0 230 1 0 0 40 2 0 0] 98 3 3664 608 1184 976 0 27 )! !
!CUWizardShell class categoriesFor: #resource_Default_view!public!resources-views! !

"Binary Globals"!

